



<html>
<head>
  <title>javabog.dk -  - Eksterne kald og JNI</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">10 <a name='afsn10'></a>Eksterne kald
og JNI</H1>
<DIV ID="Indholdsfortegnelse15">
  <P STYLE="margin-top: 0.3cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>10.1
  Kalde eksterne programmer  146</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.1.1
  Kommunikation med det eksterne program  147</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>10.2
  Kald til andre programmeringssprog  147</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.1
  JNI - Java Native Interface  147</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.2
  Skrive Java-klasser med maskinkode  147</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.3
  Skrive en metode i C++  148</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.4
  Overs&aelig;tte til maskinkode  149</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.5
  K&oslash;re programmet  149</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.6
  Kommunikation fra C-koden til Java  150</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">10.2.7
  Henvisninger  150</FONT></FONT></P>
</DIV>

<P CLASS="western" STYLE="">Undertiden f&aring;r
man brug for at kalde noget kode, der ikke er skrevet i Java. Man kan
st&aring; i to situationer:</P>
<UL>
  <LI><P CLASS="western">Man &oslash;nsker at aktivere en kommando
  eller et eksternt program fra Java.</P>
  <LI><P CLASS="western">Man &oslash;nsker af den ene eller anden
  grund at skrive noget af sit program i et andet programmeringssprog
  end Java, f.eks. for at bruge et programbibliotek, der ikke findes
  til Java.</P>
</UL>
<P CLASS="western">Det f&oslash;rste er enklere end det sidste,
hvorfor man b&oslash;r overveje, om ens problemstilling kan l&oslash;ses
ved at lave et eksternt program og kalde det.</P>
<P CLASS="western">I begge tilf&aelig;lde skal man v&aelig;re
opm&aelig;rksom p&aring;, at man mister platformsuafh&aelig;ngigheden,
dvs. l&aring;ser brugeren fast p&aring; en bestemt platform, hvis man
kalder et program eller et programbibliotek, som kun findes p&aring;
en enkelt platform (hvis man f.eks. vil bruge Windows'
win32-API-kald, har man l&aring;st brugeren af programmet fast p&aring;
Windows-platformen).</P>
<H2 CLASS="western">10.1 <a name='afsn10.1'></a>Kalde eksterne programmer</SPAN></H2>
<P CLASS="western">Hvis man vil aktivere et eksternt program fra
Java, kan man g&oslash;re dette med metoden exec(), der findes i
Runtime-klassen. I parameteren til exec() kan man skrive kommandoen,
ligesom hvis programmet var aktiveret fra kommandolinjen.</P>
<P CLASS="western">Her er et program, der kalder det eksterne program
'sort' (der er valgt, fordi det findes under b&aring;de UNIX/Linux og
DOS/Windows):</P>
<PRE CLASS="kode-western">import java.io.*;

<SPAN LANG="da-DK">public class KaldEksterntProgram</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String[] args) throws Exception</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK"><I>    // Start programmet 'sort', der sorterer linerne i en fil</I></SPAN>
<SPAN LANG="da-DK">    <B>Process proces = Runtime.getRuntime().exec(&quot;sort&quot;)</B>;</SPAN>

<SPAN LANG="da-DK"><I>    // sort kan l&aelig;se data fra standard input og skriver dem p&aring; standard output</I></SPAN>
<SPAN LANG="da-DK">    PrintWriter s = new PrintWriter(<B>proces.getOutputStream()</B>);</SPAN>
<SPAN LANG="da-DK">    BufferedReader l = new BufferedReader(</SPAN>
<SPAN LANG="da-DK">                       new InputStreamReader(<B>proces.getInputStream()</B>));</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;En&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;snegl&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;p&aring;&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;vejen&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;er&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;tegn&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;p&aring;&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;regn&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;i&quot;);</SPAN>
<SPAN LANG="da-DK">    s.println(&quot;Spanien&quot;);</SPAN>
<SPAN LANG="da-DK">    s.close(); <I>// luk datastr&oslash;mmen (sort sorterer f&oslash;rst n&aring;r den har alle data)</I></SPAN>

<SPAN LANG="da-DK"><I>    // L&aelig;s resultatet fra programmets standard output og udskriv det</I></SPAN>
<SPAN LANG="da-DK">    String lin;</SPAN>
<SPAN LANG="da-DK">    while ((lin = l.readLine()) != null) System.out.println(&quot;Fra sort: &quot;+lin);</SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Fra sort: En
<SPAN LANG="da-DK">Fra sort: er</SPAN>
<SPAN LANG="da-DK">Fra sort: i</SPAN>
<SPAN LANG="da-DK">Fra sort: p&aring;</SPAN>
<SPAN LANG="da-DK">Fra sort: p&aring;</SPAN>
<SPAN LANG="da-DK">Fra sort: regn</SPAN>
<SPAN LANG="da-DK">Fra sort: snegl</SPAN>
<SPAN LANG="da-DK">Fra sort: Spanien</SPAN>
<SPAN LANG="da-DK">Fra sort: tegn</SPAN>
<SPAN LANG="da-DK">Fra sort: vejen</SPAN></PRE>
<H3 CLASS="western">10.1.1 <a name='afsn10.1.1'></a>Kommunikation med det eksterne program</H3>
<P CLASS="western">Programmet 'sort' l&aelig;ser data fra standard
input (normalt fra tastaturet eller omdirigeret fra en fil) og
skriver dem p&aring; standard output (normalt til sk&aelig;rmen eller
omdirigeret til en fil). 
</P>
<P CLASS="western">I eksemplet f&aring;r vi fat i processens standard
input med getOutputStream() (det, vi skriver til programmet, bliver
jo programmets input) og standard output med getInputStream().</P>
<P CLASS="western">Man skal v&aelig;re opm&aelig;rksom p&aring;, at
hvis ens javaprogram fors&oslash;ger at l&aelig;se noget fra et
eksternt programs standard output, inden det har skrevet noget, vil
l&aelig;sekaldet 'h&aelig;nge', indtil der kommer data fra det
eksterne program (det kan undertiden forvirre den mindre erfarne
programm&oslash;r).</P>
<P CLASS="western">Vil man blot vente p&aring;, at det eksterne
program er k&oslash;rt f&aelig;rdigt, kan man bruge kaldet:</P>
<PRE CLASS="kode-western">    proces.waitFor();                        <I>// vent p&aring; at processen er f&aelig;rdig</I></PRE><P CLASS="western">
Det er der et eksempel p&aring; i <a href='kapitel11.jsp#afsn11.4.1'>afsnit 11.4.1</a>, Kalde overs&aelig;tteren som eksternt program.
Samme sted kan man se, hvordan man kan overf&oslash;re parametre til
det eksterne program ved simpelt hen at skrive dem efter
programnavnet:</P>
<PRE CLASS="kode-western">    Process p = r.exec(&quot;javac UndersoegKlasse.java&quot;);</PRE><P CLASS="western">
I dette tilf&aelig;lde f&aring;r javac parameteren
'UndersoegKlasse.java'.</P>

<H2 CLASS="western">10.2 <a name='afsn10.2'></a>Kald til andre programmeringssprog</SPAN></H2>
<P CLASS="western">Hvis man af den ene eller anden grund &oslash;nsker
at skrive noget af sit program i et andet programmeringssprog end
Java, f.eks. for at bruge et programbibliotek, der ikke findes til
Java, skal man bruge JNI (Java Native Interface).</P>
<H3 CLASS="western">10.2.1 <a name='afsn10.2.1'></a>JNI - Java Native Interface</H3>
<P CLASS="western">JNI giver mulighed for at:</P>
<UL>
  <LI><P CLASS="western">Kalde andre sprog fra Java, dvs. at kalde
  maskinkode fra Java. Denne maskinkode kan v&aelig;re genereret ud
  fra kildetekst skrevet i andre programmeringssprog, f.eks. C, C++
  eller Pascal.</P>
  <LI><P CLASS="western">Kalde Java fra andre sprog, dvs. starte Javas
  virtuelle maskine op, indl&aelig;se klasser og kalde metoder i dem
  fra kildetekst skrevet i andre programmeringssprog.</P>
</UL>
<P CLASS="western">I det f&oslash;lgende vil kun den f&oslash;rste
mulighed (kalde andre sprog fra Java) blive behandlet overfladisk.
&Oslash;nsker man at vide mere om JNI, findes der nogle henvisninger
i <a href='kapitel10.jsp#afsn10.2.7'>afsnit 10.2.7</a>.</P>
<H3 CLASS="western">10.2.2 <a name='afsn10.2.2'></a>Skrive Java-klasser med maskinkode</H3>
<P CLASS="western">Man kan implementere metoder i en klasse i f.eks.
C, C++ eller direkte i maskinkode ved at markere dem med n&oslash;gleordet
<B>native</B> i javakoden:</P>
<PRE CLASS="kode-western">package vp;
<SPAN LANG="da-DK">public class HejVerdenFraCKode</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public <B>native </B>void hejVerden();</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>

<P CLASS="western" STYLE="">Her er et
program, der benytter klassen HejVerdenFraCKode efter at have indl&aelig;st
den n&oslash;dvendige maskinkode:</P>
<PRE CLASS="kode-western">package vp;
<SPAN LANG="da-DK">public class BenytHejVerdenFraCKode</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  public static void main(String[] args)</SPAN>
<SPAN LANG="da-DK">  {</SPAN>
<SPAN LANG="da-DK">    System.out.println(&quot;Indl&aelig;ser maskinkoden.&quot;);</SPAN>
<SPAN LANG="da-DK"><I>    // Indl&aelig;s maskinekodebiblioteket libHej.so (UNUX) eller hej.dll (Windows)</I></SPAN>
<SPAN LANG="da-DK">    try {</SPAN>
<SPAN LANG="da-DK"><B>      System.loadLibrary(&quot;Hej&quot;);</B></SPAN>
<SPAN LANG="da-DK">    } catch (Error e) {</SPAN>
<SPAN LANG="da-DK">      System.err.println(&quot;Fejl ved indl&aelig;sning af maskinkodeblok.&quot;);</SPAN>
<SPAN LANG="da-DK">      e.printStackTrace();</SPAN>
<SPAN LANG="da-DK">      System.exit(1);      <I>// afslut programmet</I></SPAN>
<SPAN LANG="da-DK">    }</SPAN>

<SPAN LANG="da-DK">    System.out.println(&quot;Opretter objekt.&quot;);</SPAN>
<SPAN LANG="da-DK">    HejVerdenFraCKode <B>objekt = new HejVerdenFraCKode();</B></SPAN>

<SPAN LANG="da-DK">    System.out.println(&quot;Kalder metode implementeret i maskinkode.&quot;);</SPAN>
<SPAN LANG="da-DK">    <B>objekt.hejVerden();</B></SPAN>
<SPAN LANG="da-DK">  }</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<HR>
<PRE CLASS="kode-western">Indl&aelig;ser maskinkoden.
<SPAN LANG="da-DK">Opretter objekt.</SPAN>
<SPAN LANG="da-DK">Kalder metode implementeret i maskinkode.</SPAN>
<SPAN LANG="da-DK">Hej Verden fra C++ !</SPAN></PRE>
<H3 CLASS="western">10.2.3 <a name='afsn10.2.3'></a>Skrive en metode i C++</H3>
<P CLASS="western">Efter at have skrevet klassen skal den overs&aelig;ttes
til bytekode, dvs. fra .java-fil til .class-fil. Det kan g&oslash;res
i et udviklingsv&aelig;rkt&oslash;j eller fra kommandolinjen med
kommandoen:</P>
<PRE CLASS="western">  javac vp/HejVerdenFraCKode.java</PRE><P CLASS="western">
Husk, at da klassen ligger i pakken 'vp', skal den ogs&aring; ligge i
underkataloget 'vp'. 
</P>
<P CLASS="western">Nu har vi filen vp/HejVerdenFraCKode.class. S&aring;
skal der genereres en C-headerfil med:</P>
<PRE CLASS="western">  javah -jni vp.HejVerdenFraCKode</PRE><P CLASS="western">
Denne headerfil (der kommer til at hedde vp_HejVerdenFraCKode.h)
indeholder kun navnet p&aring; metoden hejVerden(), der i C-koden
bliver omd&oslash;bt til at indeholde pakkenavnet og klassenavnet
(Java_vp_HejVerdenFraCKode_hejVerden). 
</P>
<P CLASS="western">I den genererede headerfil st&aring;r:</P>
<PRE CLASS="ikke-javakode-western">/* DO NOT EDIT THIS FILE - it is machine generated */
<SPAN LANG="da-DK">#include &lt;jni.h&gt;</SPAN>
<SPAN LANG="da-DK">/* Header for class vp_HejVerdenFraCKode */</SPAN>

<SPAN LANG="da-DK">#ifndef _Included_vp_HejVerdenFraCKode</SPAN>
<SPAN LANG="da-DK">#define _Included_vp_HejVerdenFraCKode</SPAN>
<SPAN LANG="da-DK">#ifdef __cplusplus</SPAN>
<SPAN LANG="da-DK">extern &quot;C&quot; {</SPAN>
<SPAN LANG="da-DK">#endif</SPAN>
<SPAN LANG="da-DK">/*</SPAN>
<SPAN LANG="da-DK"> * Class:     vp_HejVerdenFraCKode</SPAN>
<SPAN LANG="da-DK"> * Method:    hejVerden</SPAN>
<SPAN LANG="da-DK"> * Signature: ()V</SPAN>
<SPAN LANG="da-DK"> */</SPAN>
<SPAN LANG="da-DK"><B>JNIEXPORT void JNICALL Java_vp_HejVerdenFraCKode_hejVerden (JNIEnv *, jobject);</B></SPAN>

<SPAN LANG="da-DK">#ifdef __cplusplus</SPAN>
<SPAN LANG="da-DK">}</SPAN>
<SPAN LANG="da-DK">#endif</SPAN>
<SPAN LANG="da-DK">#endif</SPAN></PRE>

<P CLASS="western" STYLE="">Denne metode
skal vi selv implementere i f.eks. C++. Vi opretter derfor en fil
kaldet vp_HejVerdenFraCKode.cpp og skriver C++-koden, der
implementerer metoden:</P>
<PRE CLASS="ikke-javakode-western">#include &quot;vp_HejVerdenFraCKode.h&quot; 
<SPAN LANG="da-DK">#include &lt;stdio.h&gt;</SPAN>

<SPAN LANG="da-DK">JNIEXPORT void JNICALL Java_vp_HejVerdenFraCKode_hejVerden (JNIEnv *e, jobject o)</SPAN>
<SPAN LANG="da-DK">{</SPAN>
<SPAN LANG="da-DK">  printf(&quot;Hej Verden fra C++ !\n&quot;);</SPAN>
<SPAN LANG="da-DK">}</SPAN></PRE>
<P CLASS="western">Denne kode skal overs&aelig;ttes til et bibliotek
med maskinkode (eng.: shared library), der kan indl&aelig;ses fra
Java. Pr&aelig;cist hvordan dette g&oslash;res afh&aelig;nger af
styresystemet. 
</P>
<H3 CLASS="western">10.2.4 <a name='afsn10.2.4'></a>Overs&aelig;tte til maskinkode</H3>
<P CLASS="western">Fra UNIX/Linux kunne det g&oslash;res ved at kalde
standard C++-overs&aelig;tteren:</P>
<PRE CLASS="western"> g++ -shared -g -I/usr/include/java vp_HejVerdenFraCKode.cpp -o libHej.so</PRE><P CLASS="western">
Man skal huske, at '/usr/include/java' skal pege hen p&aring;, hvor
ens Java-headerfiler findes. Det kan ogs&aring; v&aelig;re, at man er
n&oslash;dt til at inkludere flere kataloger med yderligere
headerfiler, f.eks.:</P>
<PRE CLASS="western"> g++ -shared -g -I/usr/local/java/include  -I/usr/local/java/include/linux \
<SPAN LANG="da-DK">  vp_HejVerdenFraCKode.cpp -o libHej.so</SPAN></PRE><P CLASS="western">
Under UNIX/Linux genereres en .so-fil (som her hedder libHej.so).
Under Windows skal der genereres en .DLL-fil (dynamic link library),
der tilsvarende ville hedde Hej.DLL (pr&aelig;cis hvordan man g&oslash;r
afh&aelig;nger af, hvilken C++-overs&aelig;tter man bruger).</P>
<H3 CLASS="western">10.2.5 <a name='afsn10.2.5'></a>K&oslash;re programmet</H3>
<P CLASS="western">N&aring;r kommandoen System.loadLibrary(&quot;Hej&quot;)
kaldes i eksemplets main()-metode ovenfor bliver filen libHej.so 
eller Hej.DLL (afh&aelig;ngig af styresystemet) indl&aelig;st af den
virtuelle  maskine og l&aelig;nket sammen med resten af programmet. 
</P>
<P CLASS="western">Vi starter programmet med:</P>
<PRE CLASS="western"> java vp.HejVerdenFraCKode</PRE><P CLASS="western">
Hvis den genererede maskinkode ikke ligger der hvor systemet i &oslash;vrigt
l&aelig;gger sine maskinkodebiblioteker (dvs. i /usr/lib/ under UNIX
og c:\win\system\ under Windows), f&aring;r man fejlen:</P>
<PRE CLASS="kode-western">Indl&aelig;ser maskinkoden.
<SPAN LANG="da-DK">Fejl ved indl&aelig;sning af maskinkodeblok.</SPAN>
<SPAN LANG="da-DK">java.lang.UnsatisfiedLinkError: no Hej in java.library.path</SPAN>
<SPAN LANG="da-DK">        at java.lang.ClassLoader.loadLibrary(ClassLoader.java:1403)</SPAN>
<SPAN LANG="da-DK">        at java.lang.Runtime.loadLibrary0(Runtime.java:788)</SPAN>
<SPAN LANG="da-DK">        at java.lang.System.loadLibrary(System.java:832)</SPAN>
<SPAN LANG="da-DK">        at vp.HejVerdenFraCKode.main(HejVerdenFraCKode.java:11)</SPAN></PRE><P CLASS="western">
Da kan man fort&aelig;lle den virtuelle maskine, at den skal lede
efter maskinkode i det aktuelle katalog ('.') med:</P>
<PRE CLASS="western"> java -Djava.library.path=. vp.HejVerdenFraCKode</PRE><P CLASS="western">
Nu udskriver programmet:</P>
<PRE CLASS="kode-western">Indl&aelig;ser maskinkoden.
<SPAN LANG="da-DK">Opretter objekt.</SPAN>
<SPAN LANG="da-DK">Kalder metode implementeret i maskinkode.</SPAN>
<SPAN LANG="da-DK">Hej Verden fra C++ !</SPAN></PRE><P CLASS="western">
Den sidste linje bliver udskrevet fra C++, s&aring; det lykkedes os
at bruge JNI.</P>

<H3 CLASS="western" STYLE="">10.2.6 <a name='afsn10.2.6'></a>Kommunikation
fra C-koden til Java</H3>
<P CLASS="western">Ser man n&aelig;rmere p&aring; erkl&aelig;ringen
af metoden opdager man, at selvom java-metoden ikke havde nogle
parametre, s&aring; har C-koden to parametre:</P>
<PRE CLASS="ikke-javakode-western">JNIEXPORT void JNICALL Java_vp_HejVerdenFraCKode_hejVerden (JNIEnv *e, jobject o)</PRE>
<P CLASS="western">Den f&oslash;rste er en pointer til den virtuelle
maskine. Den skal bruges, hvis man &oslash;nsker at kommunikere med
den virtuelle maskine, f.eks. hvis man vil oprette nye Java-objekter
fra C-koden.</P>
<P CLASS="western">Den anden variabel er en pointer til objektet
(instansen af HejVerdenFraCKode), som metoden blev kaldt p&aring;
(eller klassen, hvis metoden hejVerden havde v&aelig;ret en
klassemetode).</P>
<P CLASS="western">Disse to pointere bruges i udstrakt grad i JNI til
at f&aring; adgang til metoder eller variabler i objektet eller
klassen, til at oprette objekter etc. etc.</P>
<P CLASS="western">Man skal v&aelig;re opm&aelig;rksom p&aring;, at
den virtuelle maskine kan finde p&aring; at flytte rundt p&aring;
objekterne i hukommelsen, n&aring;r den rydder op i ubrugte objekter
(garbage collection). Derfor skal man fra C-koden fort&aelig;lle den
virtuelle maskine, hvilke objekter man er i gang med at arbejde i, s&aring;
den ikke flytter dem samtidig.</P>

<H3 CLASS="western">10.2.7 <a name='afsn10.2.7'></a>Henvisninger</H3>
<UL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Suns dokumentation af JNI
  findes p&aring;
  <BR></SPAN><SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://java.sun.com/products/jdk/1.3/docs/guide/jni/"><SPAN LANG="da-DK">http://java.sun.com/products/jdk/1.3/docs/guide/jni/</SPAN></A></SPAN></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">&Oslash;nsker du for alvor
  at bruge JNI har Kristian Hansens bog 'Avanceret
  Java-programmering', der kan hentes gratis p&aring;
  </SPAN><SPAN STYLE="font-weight: medium"><A CLASS="western" HREF="http://bog.ing.dk/"><SPAN LANG="da-DK">http://bog.ing.dk/</SPAN></A></SPAN><SPAN LANG="da-DK">,
  en meget grundig behandling af emnet. </SPAN>
  </P>
</UL>



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_VP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (71% af vrket).
</font>
<br>
nsker du at se de sidste 29% af dette vrk (362838 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
